// --------------------------------- lmsdrvr.h --------------------------------
//
//  Include file for Linux LabBrick LMS signal generator definitions
//
// (c) 2020-2024 by Vaunix Technology Corporation
//
//  JA  Version 1.0 LMS Digital Signal Generator Device Driver
//	RD	6/2024
//-----------------------------------------------------------------------------
#ifndef __LMSDRVR_H__
#define __LMSDRVR_H__

//*****************************************************************************
//
// If building with a C++ compiler, make all of the definitions in this header
// have a C binding.
//
//*****************************************************************************
#ifdef __cplusplus
extern "C"
{
#endif

/// ---------- Macros ----------------
// Status returns for commands
#define LVSTATUS 			unsigned int
#define DEVID 				unsigned int


// LMS Device Init
void fnLMS_Init(void);

// LMS Set Test mode
void fnLMS_SetTestMode(bool testmode);

// Get library version as an integer
int fnLMS_GetLibVersion(void);

// Get library version as a string
char *fnLMS_GetVersionStr(void);

// Get the number of LMS Devices present
int fnLMS_GetNumDevices();

// Get Information for the attached devices
int fnLMS_GetDevInfo(DEVID *ActiveDevices);

// Get LMS Device Model Name
int fnLMS_GetModelName(DEVID deviceID, char * ModelName);

// Init LMS Device to open a device for usage
int fnLMS_InitDevice(DEVID deviceID);

// LMS Device close connection
int fnLMS_CloseDevice(DEVID deviceID);

// Get Serial # of LMS Device
int fnLMS_GetSerialNumber(DEVID deviceID);

// Get Frequency of LMS Device
int fnLMS_GetFrequency(DEVID deviceID);

// Get sweep Start Frequency of LMS Device
int fnLMS_GetStartFrequency(DEVID deviceID);

// Get sweep End Frequency of LMS Device
int fnLMS_GetEndFrequency(DEVID deviceID);

// Get freq Step size from the LMS Device
int fnLMS_GetFrequencystep(DEVID deviceID);

// Get Sweep Time Configuration of LMS Device
int fnLMS_GetSweepTime(DEVID deviceID);

// Get RF On status of LMS Device
int fnLMS_GetRF_On(DEVID deviceID);

// Get UseInternal Reference clock status
int fnLMS_GetUseInternalRef(DEVID deviceID);

// Get Use External Sweep Trigger status
int fnLMS_GetUseExtSweepTrigger(DEVID deviceID);

// Get Powerlevel Status of LMS Device
int fnLMS_GetPowerLevel(DEVID deviceID);

// Get Max Power Level of LMS Device
int fnLMS_GetMaxPwr(DEVID deviceID);

// Get Minimum Power Level of LMS Device
int fnLMS_GetMinPwr(DEVID deviceID);

// Get Maximum Frequency of LMS Device
int fnLMS_GetMaxFreq(DEVID deviceID);

// Get Minimum Frequency of LMS Device
int fnLMS_GetMinFreq(DEVID deviceID);

// Get Pulse On Time of LMS Device
float fnLMS_GetPulseOnTime(DEVID deviceID);

// Get Pulse Off Time of LMS Device
float fnLMS_GetPulseOffTime(DEVID deviceID);

// Get Pulse Mode Status of LMS Device
int fnLMS_GetPulseMode(DEVID deviceID);

// Get Fast Pulse Mode status of device
int fnLMS_GetHasFastPulseMode(DEVID deviceID);

// Get Internal Pulse Mode Status of device
int fnLMS_GetUseInternalPulseMod(DEVID deviceID);

// Get sweep bi-directional mode of device
int fnLMS_GetSweepbidirectionalmode(DEVID deviceID);

// Get sweep mode of device
int fnLMS_GetSweepmode(DEVID deviceID);

// Get PLL lock status of device
int fnLMS_GetPLLLock(DEVID deviceID);

// Get the complete set of status bits
int fnLMS_GetDeviceStatus(DEVID deviceID);

// Chirp parameters
float fnLMS_GetChirpLength(DEVID deviceID);
float fnLMS_GetChirpRepeatRate(DEVID deviceID);
int fnLMS_GetHasChirpMode(DEVID deviceID);

// Set Frequency 
LVSTATUS fnLMS_SetFrequency(DEVID deviceID, int frequency);

// Set sweep Start Frequency
LVSTATUS fnLMS_SetStartFrequency(DEVID deviceID, int startfrequency);

// Set sweep End Frequency
LVSTATUS fnLMS_SetEndFrequency(DEVID deviceID, int endfrequency);

// Set Frequency Step 
LVSTATUS fnLMS_SetFrequencystep(DEVID deviceID, int freqstep);

// Set Power Level 
LVSTATUS fnLMS_SetPowerLevel(DEVID deviceID, int powerlevel);

// Set RF On Status
LVSTATUS fnLMS_SetRFOn(DEVID deviceID, bool on);

// Set Pulse On Time
LVSTATUS fnLMS_SetPulseOnTime(DEVID deviceID, float pulseontime);

// Set Pulse Off Time
LVSTATUS fnLMS_SetPulseOffTime(DEVID deviceID, float pulseofftime);

// Set Fast Pulsed Output mode
LVSTATUS fnLMS_SetFastPulsedOutput(DEVID deviceID, float pulseontime, float pulsereptime, bool on);

// Enable Pulse Modulation
LVSTATUS fnLMS_EnableInternalPulseMod(DEVID deviceID, bool on);

// Set External Pulse Mode
LVSTATUS fnLMS_SetUseExternalPulseMod(DEVID deviceID, bool external);

// Set Internal Reference
LVSTATUS fnLMS_SetUseInternalRef(DEVID deviceID, bool internal);

// Set External sweep trigger
LVSTATUS fnLMS_SetUseExtSweepTrigger(DEVID deviceID, bool external);

// Set Sweep time
 LVSTATUS fnLMS_SetSweepTime(DEVID deviceID, int sweeptime);

// Set Sweep Direction
LVSTATUS fnLMS_SetSweepDirection(DEVID deviceID, bool up);

// Set Sweep bidirectional
LVSTATUS fnLMS_SetSweepbidirection(DEVID deviceID, bool bidir);

// Set Sweep Mode
LVSTATUS fnLMS_SetSweepMode(DEVID deviceID, bool mode);

// Set Sweep Type
LVSTATUS fnLMS_SetSweepType(DEVID deviceID, bool swptype);

// Start Sweep
LVSTATUS fnLMS_StartSweep(DEVID deviceID, bool go);

// Chirp parameters
LVSTATUS fnLMS_SetChirpMode(DEVID deviceID, bool mode);
LVSTATUS fnLMS_SetChirpLength(DEVID deviceID, float chirplength);
LVSTATUS fnLMS_SetChirpRepeatRate(DEVID deviceID, float chirp_repeat);

// Save Settings for persistence 
LVSTATUS fnLMS_SaveSettings(DEVID deviceID);

// Sending Raw Message over USB HID bus
LVSTATUS fnLMS_SendRawmsg_USBHID(DEVID deviceID, char *buff);

// Error Status
char *fnLMS_perror(LVSTATUS status);
char *fnLMS_pFloatError(float fstatus);

//*****************************************************************************
//
// Mark the end of the C bindings section for C++ compilers.
//
//*****************************************************************************
#ifdef __cplusplus
}
#endif

#endif // __LMSDRVR_H__                             
